/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ArenaDisplay
extends Canvas {
    private Font defFont;
    private int tileWidth;
    private int tileHeight;
    private int tileCountX;
    private int tileCountY;
    private int tileOffsetX;
    private int tileOffsetY;
    private int bufferX;
    private int bufferY;
    private Arena arena;
    private int[] palette;
    private Main controller;

    private int tileCount(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        if ((n3 & 1) != 1) {
            ++n3;
        }
        return n3;
    }

    public ArenaDisplay(Arena arena, int[] nArray, Main main) {
        this.arena = arena;
        this.palette = nArray;
        this.controller = main;
        this.defFont = Font.getFont((int)32, (int)0, (int)8);
        this.tileHeight = this.defFont.getHeight();
        this.tileWidth = this.defFont.charWidth('m');
        this.tileCountX = this.tileCount(this.getWidth(), this.tileWidth);
        this.tileCountY = this.tileCount(this.getHeight(), this.tileHeight);
        if (this.tileCountX > this.arena.getWidth()) {
            this.tileCountX = this.arena.getWidth();
        }
        if (this.tileCountY > this.arena.getHeight()) {
            this.tileCountY = this.arena.getHeight();
        }
        this.tileOffsetX = (this.getWidth() - this.tileCountX * this.tileWidth) / 2 + this.tileWidth / 2;
        this.tileOffsetY = (this.getHeight() - this.tileCountY * this.tileHeight) / 2;
        this.bufferX = (this.tileCountX - 1) / 2;
        this.bufferY = (this.tileCountY - 1) / 2;
    }

    protected void paint(Graphics graphics) {
        int n = this.arena.getRobotX();
        int n2 = this.arena.getRobotY();
        graphics.setColor(this.palette[0]);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n3 = n < this.bufferX - 1 ? -1 : (n > this.arena.getWidth() - 1 - this.bufferX ? this.arena.getWidth() - 1 - this.tileCountX + 2 : n - (this.tileCountX - 1) / 2);
        int n4 = n2 < this.bufferY - 1 ? -1 : (n2 > this.arena.getHeight() - 1 - this.bufferY ? this.arena.getHeight() - 1 - this.tileCountY + 2 : n2 - (this.tileCountY - 1) / 2);
        graphics.setFont(this.defFont);
        block4: for (int i = n4; i < n4 + this.tileCountY; ++i) {
            if (i < 0) continue;
            if (i > this.arena.getHeight() - 1) break;
            block5: for (int j = n3; j < n3 + this.tileCountX; ++j) {
                if (j < 0) continue;
                if (j > this.arena.getWidth() - 1) continue block4;
                switch (this.arena.typeAt(j, i)) {
                    case 2: 
                    case 3: {
                        this.drawTile(graphics, this.arena.glyphAt(j, i), this.arena.colorAt(j, i), j, i, n3, n4);
                        continue block5;
                    }
                    case 4: {
                        this.drawTile(graphics, this.arena.glyphAt(j, i), -1, j, i, n3, n4);
                    }
                }
            }
        }
        this.drawTile(graphics, '#', -1, n, n2, n3, n4);
    }

    private void drawTile(Graphics graphics, char c, int n, int n2, int n3, int n4, int n5) {
        if (n == -1) {
            graphics.setColor(this.palette[this.palette.length - 1]);
        } else {
            graphics.setColor(this.palette[n % (this.palette.length - 1) + 1]);
        }
        graphics.drawChar(c, this.tileOffsetX + (n2 - n4) * this.tileWidth, this.tileOffsetY + (n3 - n5) * this.tileHeight, 0x10 | 1);
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        int n3 = this.arena.getRobotX();
        int n4 = this.arena.getRobotY();
        switch (n2) {
            case 1: {
                if (n4 <= 0) break;
                --n4;
                break;
            }
            case 6: {
                if (n4 >= this.arena.getHeight() - 1) break;
                ++n4;
                break;
            }
            case 2: {
                if (n3 <= 0) break;
                --n3;
                break;
            }
            case 5: {
                if (n3 >= this.arena.getWidth() - 1) break;
                ++n3;
                break;
            }
        }
        switch (this.arena.typeAt(n3, n4)) {
            case 1: 
            case 4: {
                return;
            }
            case 2: {
                this.controller.foundKitten();
                break;
            }
            case 3: {
                this.controller.foundNKI(this.arena.messageAt(n3, n4));
                break;
            }
            case 0: {
                this.arena.setRobotX(n3);
                this.arena.setRobotY(n4);
                this.repaint();
            }
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }
}

