/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Main
extends MIDlet
implements CommandListener {
    private Display display;
    private Displayable nextPage = null;
    private Arena gameArena = null;
    private Command doExit;
    private Command doPause;
    private Command doDismiss;
    private int[] colorPal = new int[]{0, 0xFF5555, 0x55FF55, 0xFFFF55, 0x5555FF, 0xFF55FF, 0x55FFFF, 0xFFFFFF};
    private int[] bwPal = new int[]{0, 0xFFFFFF};

    public Main() {
        this.display = Display.getDisplay((MIDlet)this);
        this.doExit = new Command("Exit", 7, 1);
        this.doDismiss = new Command("Dismiss", 7, 1);
        this.doPause = new Command("Pause", 7, 1);
    }

    public void startApp() {
        if (this.gameArena != null) {
            this.display.setCurrent(this.makeGamePage(this.gameArena));
        } else {
            this.loadState();
            this.display.setCurrent(this.makeStartupPage());
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.saveState();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.doExit) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.doDismiss) {
            this.display.setCurrent(this.nextPage);
            this.nextPage = null;
        } else if (command == this.doPause) {
            this.nextPage = null;
            this.display.setCurrent(this.makeStartupPage());
        } else if (command == List.SELECT_COMMAND) {
            List list = (List)displayable;
            String string = list.getString(list.getSelectedIndex());
            if (string == "New game") {
                this.gameArena = new Arena();
                this.nextPage = null;
                this.display.setCurrent(this.makeGamePage(this.gameArena));
            } else if (string == "Continue game") {
                if (this.gameArena != null) {
                    this.nextPage = null;
                    this.display.setCurrent(this.makeGamePage(this.gameArena));
                } else {
                    Alert alert = new Alert("Can't continue", "There is no current game to continue", null, null);
                    alert.setTimeout(-2);
                    this.display.setCurrent(alert, this.display.getCurrent());
                }
            } else if (string == "Instructions") {
                Form form = new Form("Instructions");
                form.append((Item)new StringItem("", "In this game, you are robot (#). Your job is to find kitten. This task is complicated by the existence of various things which are not kitten. "));
                form.append((Item)new StringItem("", "Robot must touch items to determine if they are kitten or not. The game ends when robotfindskitten."));
                form.addCommand(this.doDismiss);
                form.setCommandListener((CommandListener)this);
                this.nextPage = this.display.getCurrent();
                this.display.setCurrent((Displayable)form);
            } else if (string == "About") {
                Form form = new Form("About robotfindskitten");
                try {
                    Image image = Image.createImage((String)"/rfklogo.png");
                    form.append((Item)new ImageItem("", image, 771, "robotfindskitten"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                form.append((Item)new StringItem("", "This version of robotfindskitten is a re-implementation of the original robotfindskitten for Linux."));
                form.append((Item)new StringItem("", "For more information, and versions of robotfindskitten for other platforms (PalmOS, Dreamcast, Gameboy Advance, Commodore 64, OpenGL...) see the official website: http://robotfindskitten.org"));
                form.addCommand(this.doDismiss);
                form.setCommandListener((CommandListener)this);
                this.nextPage = this.display.getCurrent();
                this.display.setCurrent((Displayable)form);
            }
        }
    }

    public Displayable makeStartupPage() {
        List list = new List("robotfindskitten", 3);
        if (this.gameArena != null) {
            list.append("Continue game", null);
        }
        list.append("New game", null);
        list.append("Instructions", null);
        list.append("About", null);
        list.addCommand(this.doExit);
        list.addCommand(List.SELECT_COMMAND);
        list.setCommandListener((CommandListener)this);
        return list;
    }

    public Displayable makeGamePage(Arena arena) {
        int[] nArray = this.display.isColor() ? this.colorPal : this.bwPal;
        ArenaDisplay arenaDisplay = new ArenaDisplay(arena, nArray, this);
        arenaDisplay.addCommand(this.doPause);
        arenaDisplay.setCommandListener(this);
        return arenaDisplay;
    }

    public void foundNKI(String string) {
        Form form = new Form("Kitten?");
        form.append((Item)new StringItem("", string));
        form.addCommand(this.doDismiss);
        form.setCommandListener((CommandListener)this);
        this.nextPage = this.display.getCurrent();
        this.display.setCurrent((Displayable)form);
    }

    public void foundKitten() {
        Form form = new Form("Way to go!");
        try {
            Image image = Image.createImage((String)"/waytogorobot.png");
            form.append((Item)new ImageItem("", image, 771, "robotfindskitten"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        form.append((Item)new StringItem("", "Way to go, robot! You found kitten!"));
        form.addCommand(this.doDismiss);
        form.setCommandListener((CommandListener)this);
        this.gameArena = null;
        this.nextPage = this.makeStartupPage();
        this.display.setCurrent((Displayable)form);
    }

    private void saveState() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            RecordStore.deleteRecordStore((String)"ArenaState");
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (this.gameArena == null) {
            return;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"ArenaState", (boolean)true);
            dataOutputStream.writeLong(this.gameArena.getSeed());
            dataOutputStream.writeInt(this.gameArena.getRobotX());
            dataOutputStream.writeInt(this.gameArena.getRobotY());
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("Got an exception storing theArena state:" + exception.toString());
        }
    }

    private void loadState() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"ArenaState", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
            if (!recordEnumeration.hasNextElement()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordEnumeration.nextRecord()));
            this.gameArena = new Arena(dataInputStream.readLong());
            this.gameArena.setRobotX(dataInputStream.readInt());
            this.gameArena.setRobotY(dataInputStream.readInt());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.gameArena = null;
            System.out.println("Got an exception reading theArena state:" + exception.toString());
        }
    }
}

